import re

node = hou.pwd()
geo = node.geometry()

text_attrib = geo.addAttrib(hou.attribType.Point, "name", "blank")
target_attrib = geo.addArrayAttrib(hou.attribType.Point, "target",hou.attribData.String,1)
#geo.addArrayAttrib( hou.attribType.Point, "myAttrib", hou.attribData.Float, 1 )

filepath = node.evalParm("twee")
block_list=[]
c_list=[]
with open(filepath) as fp:  
    data = fp.read()
    nodes = data.split("::")
    del nodes[0]
    del nodes[0]
    del nodes[len(nodes)-1]
    #print nodes[0]
    
    for node in nodes:
        result = re.search('<(.*)>', node)
        coord = result.group(0)
        coord = coord[1:-1]
        x = float(coord.split(",")[0])
        y = float(coord.split(",")[1])
        
        link_list = []
        link_list = re.findall(r'\[\[(.*?)\]\]', node)
        #print node.split("\n")[0]
        block = {
            "name":node.split("\n")[0].split(" [")[0],
            "loc":node.split("[")[1].split("]")[0],
            "x":x,
            "y":y,
            "links":link_list
        }
        c_block = {
            't_name':node.split("\n")[0].split(" [")[0],
            'c_name':node.split("[")[1].split("]")[0]
        }
        
        
        block_list.append(block)
        c_list.append(c_block)

def search(name, people):
    return [element for element in people if element['t_name'] == name]

def search_l(name, people):
    return [element for element in people if element['loc'] == name]

        
for b in block_list:
    
    #print "name: "+b['name']+" ||| location: ||| "+c_name[0]['c_name']
    #b['name'] = c_name[0]['c_name']
    #print b["name"]
    #print b["loc"]
    #print b["x"]
    #print b["y"]
    
    links = b["links"]
    n_links = []
    for link in links:
        if "->" in link:
            link = link.split("->")[1]
        if "|" in link:
            link = link.split("|")[1]
        #print link
        c_name = search(link,c_list)
        if c_name:
            n_links.append(c_name[0]['c_name'])
    #print n_links
    b['links']=n_links
    #print b['links']
    
    #print "\n"

def f2(seq): 
   # order preserving
   checked = []
   for e in seq:
       if e not in checked:
           checked.append(e)
   return checked
    
def c(L):

    location = []
    d = []

    for loc in L:
        #print loc
        location.append(loc['loc'])
    

    location = f2(location)
    
    for loc in location:
        x = 0
        y = 0 
        links =[]
        for q in L:
                
            if loc == q['loc']:
                #print loc
                
                loc = q['loc']
                if(x>0):
                    x += q['x']
                    y += q['y']
                
                    x/=2
                    y/=2
                else:    
                    x=q['x']
                    y=q['y']
                links += q['links']
                #print q['links']
        block = {
            "loc":loc,
            "x":x,
            "y":y,
            "links":f2(links)
            }
        d.append(block)
    for x in d:
        a=1
        #print x
    return d
       
pt = c(block_list)

for d in pt:
    #print "make points"
    x= d['x']
    y= d['y']
    loc = d['loc']
    target = d['links']
    
    
    for t in target:
        print t
        t_x=search_l(t,pt)[0]['x']
        t_y=search_l(t,pt)[0]['y']
        print '\n \n'
        
    
        p1 = geo.createPoint()
        p1.setPosition([x,0,y])
        p1.setAttribValue(text_attrib, loc)
        p1.setAttribValue(target_attrib, target)
        
        p2 = geo.createPoint()
        p2.setPosition([t_x,0,t_y])
        p2.setAttribValue(text_attrib, t)
        
        poly = geo.createPolygon()
        poly.setIsClosed(False)
        
        poly.addVertex(p1)
        poly.addVertex(p2)

        
   
